unit HttpDemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  HTTPSend, StdCtrls, ExtCtrls,
  stCustomProtoComp, stSecComp, StreamSec.DSI.KeyManager,
  StreamSec.Mobile.X509Comp, StreamSec.Mobile.TlsInternalServer,
  stResourceFile, StreamSec.DSI.PkixCert, StreamSec.Mobile.TlsClass, ComCtrls,
  CheckLst, SelectCipherSuitesFrame;

type
  TForm1 = class(TForm)
    Panel3: TPanel;
    Panel4: TPanel;
    Memo1: TMemo;
    Memo2: TMemo;
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Label2: TLabel;
    TLSInternalServer1: TsmSimpleTLSInternalServer;
    StatusBar1: TStatusBar;
    TfrmSelectCipherSuites1: TfrmSelectCipherSuites;
    stResourceFile1: TstResourceFile;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TLSInternalServer1CertNotAccepted(Sender: TObject; const Cert:
        iCertificate; Status: TCertStatusCode; var aRetry: Boolean);
    procedure TLSInternalServer1TLSIncomingAlert(Sender: TObject;
      Client: TCustomTLS_ContentLayer; var Fatal: Boolean;
      AlertCode: Integer);
    procedure TLSInternalServer1TLSOutgoingAlert(Sender: TObject;
      Client: TCustomTLS_ContentLayer; var Fatal: Boolean;
      AlertCode: Integer);
    procedure TLSInternalServer1CertNotTrusted(Sender: TObject;
      const Cert: iCertificate; var ExplicitTrust: Boolean);
    procedure TLSInternalServer1TLSChangeCipherSpec(Sender: TObject; Client:
        TCustomTLS_ContentLayer);
  private
    FAllowAll: Boolean;
    FAllowNone: Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  stMD2,
  TypInfo,
  SSL_StreamSec4,
  StreamSec.Mobile.Tls,
  StreamSec.Mobile.TlsConst;

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);

  function DoIt: Boolean;
  var
    HTTP: THTTPSend;
  begin
    HTTP := THTTPSend.Create;
    try
      Result := HTTP.HTTPMethod('GET', Edit1.text);
      Memo1.Lines.Assign(HTTP.Headers);
      HTTP.Document.Position := 0;
      Memo2.Lines.LoadFromStream(HTTP.Document);
    finally
      HTTP.Free;
    end;
  end;

begin
  TLSInternalServer1.TLSSetupClient;
  StreamSec.Mobile.TlsConst.VersionMinorMax := cTLS12vmm;
  if not DoIt then begin
    StreamSec.Mobile.TlsConst.VersionMinorMax := cTLS10vmm;
    DoIt;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  lTmpFileName: string;
begin
  StreamSec.Mobile.TLSInternalServer.GlobalServer := TLSInternalServer1;
  lTmpFileName := IncludeTrailingPathDelimiter(GetCurrentDir) + 'root.p7b';
  (stResourceFile1.DataStream as TCustomMemoryStream).SaveToFile(lTmpFileName);
  TLSInternalServer1.LoadRootCertsFromFile(lTmpFileName);
  DeleteFile(lTmpFileName);
  TLSInternalServer1.OnCertNotAccepted := nil;
  TfrmSelectCipherSuites1.Options := TLSInternalServer1.Options;
end;

procedure TForm1.TLSInternalServer1CertNotAccepted(Sender: TObject; const Cert:
    iCertificate; Status: TCertStatusCode; var aRetry: Boolean);
begin
  if Status = crcInvalidSignature then begin
    if FAllowAll then
      aRetry := True
    else if FAllowNone then
      aRetry := False
    else
      case MessageDlg('A certificate was not accepted:'#13#10 + Cert.ErrorMsg + #13#10'Allow anyway?',
                      mtConfirmation,[mbYes,mbNo,mbYesToAll,mbNoToAll],0) of
        mrYes:
          aRetry := True;
        mrNo:
          aRetry := False;
        mrYesToAll:
          begin
            FAllowAll := True;
            aRetry := True;
          end;
        mrNoToAll:
          begin
            FAllowNone := True;
            aRetry := False;
          end;
      end;
  end else
    MessageDlg('A certificate was not accepted:'#13#10 + GetEnumName(TypeInfo(TCertStatusCode),Ord(Status)),mtWarning,[mbOK],0)
end;

procedure TForm1.TLSInternalServer1CertNotTrusted(Sender: TObject;
  const Cert: iCertificate; var ExplicitTrust: Boolean);
begin
  // This causes ALL formally valid server certificates to be accepted,
  // regardless of how they were issued and by whom.
  // WARNING! Enabling ExplicitTrust will introduce an exploitable weakness.
  //
  // ExplicitTrust := True;
end;

procedure TForm1.TLSInternalServer1TLSChangeCipherSpec(Sender: TObject; Client:
    TCustomTLS_ContentLayer);
begin
  StatusBar1.SimpleText := GetCipherSuiteName(Client.CipherSuite,Client.Version,TLSInternalServer1.Options.OnlyStandardCipherSuites);
end;

procedure TForm1.TLSInternalServer1TLSIncomingAlert(Sender: TObject;
  Client: TCustomTLS_ContentLayer; var Fatal: Boolean; AlertCode: Integer);
var
  Msg: string;
begin
  if AlertCode = 0 then
    Msg := 'Incoming close notification'#13#10
  else if Fatal then
    Msg := 'Incoming fatal alert ' + IntToStr(AlertCode) + #13#10
  else
    Msg := 'Incoming warning ' + IntToStr(AlertCode) + #13#10;
  Msg := Msg + StreamSec.Mobile.TlsConst.AlertMsg(AlertCode);
  if AlertCode <> 0 then
    MessageDlg(Msg,mtWarning,[mbAbort],0)
end;

procedure TForm1.TLSInternalServer1TLSOutgoingAlert(Sender: TObject;
  Client: TCustomTLS_ContentLayer; var Fatal: Boolean; AlertCode: Integer);
var
  Msg: string;
begin
  if AlertCode = 0 then
    Msg := 'Outgoing close notification'#13#10
  else if Fatal then
    Msg := 'Outgoing fatal alert ' + IntToStr(AlertCode) + #13#10
  else
    Msg := 'Outgoing warning ' + IntToStr(AlertCode) + #13#10;
  Msg := Msg + StreamSec.Mobile.TlsConst.AlertMsg(AlertCode);
  if AlertCode <> 0 then begin
    if Fatal then
      MessageDlg(Msg,mtWarning,[mbAbort],0)
    else
      Fatal := MessageDlg(Msg,mtWarning,[mbIgnore,mbAbort],0) = mrAbort;
  end;
end;

end.
